/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015 - 2021, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdnalioctl.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsdnalioctl.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_
#define SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_

#include <sys/ioccom.h>
#include <freebsddefs.h>
#include <naltypes.h>
#include <freebsdtypes.h>

#ifndef NAL_DRIVER
#include <device_t.h>
#endif

/*
 *  The macro for definitions of NAL IOCTL commands.
 */
#define NAL_MAKE_IOCTL( IoCtlNumber )               _IOWR( NAL_OS_SPEC_IOCTL_GROUP_NUMBER , IoCtlNumber , NAL_IOCTL_INPUT_DATA )

#ifndef NAL_DRIVER
/* ===========================================================================================================
 *                                        USER SPACE PROTOTYPES
   =========================================================================================================*/

/* Macro for sending IOCTL commands - required by nalioctl.c file */
#define NAL_SEND_IOCTL(NalIoctlNumber, InputBuffer, InputBufferSize, OutputBuffer, OutputBufferSize)\
    {                                                                                               \
        if(Global_OsVariables.NalFileDescriptor != -1)                                              \
        {                                                                                           \
            ioctl(Global_OsVariables.NalFileDescriptor, NalIoctlNumber, InputBuffer);               \
            UNREFERENCED_PARAMETER(InputBufferSize);                                                \
            UNREFERENCED_PARAMETER(OutputBuffer);                                                   \
            UNREFERENCED_PARAMETER(OutputBufferSize);                                               \
        }                                                                                           \
    }

KVOID*
_NalAllocateMemoryNonPagedPciIoctl(
    IN  KVOID*                          PDev,
    IN  UINT32                          ByteCount,
    IN  UINT32                          Alignment,
    OUT NAL_PHYSICAL_ADDRESS*           PhysicalAddress OPTIONAL,
    IN  CHAR*                           NamedLocator,
    IN  UINT32                          LineNumber
    );

VOID
_NalFreeMemoryNonPagedPciIoctl(
    IN  KVOID*                          PDev,
    IN  KVOID*                          Address
    );

NAL_STATUS
_NalFillDeviceResourceIoctl(
    IN  NAL_OS_SPEC_DEVICE_CONTEXT*     DeviceContext,
    IN  NAL_DEVICE_LOCATION             PciLocation,
    IN OUT NAL_DEVICE*                  Device
    );

NAL_STATUS
_NalDeviceResourceIoctl(
    IN  UINT64                          FunctionId,
    IN  NAL_OS_SPEC_DEVICE_CONTEXT*     DeviceContext,
    IN  NAL_DEVICE_LOCATION             PciLocation,
    IN OUT NAL_DEVICE*                  Device
    );

NAL_STATUS
_NalRequestDeviceResourceIoctl(
    IN  NAL_OS_SPEC_DEVICE_CONTEXT*     DeviceContext,
    IN  NAL_DEVICE_LOCATION             PciLocation,
    IN OUT NAL_DEVICE*                  Device
    );

NAL_STATUS
_NalReleaseDeviceResourceIoctl(
    IN  NAL_OS_SPEC_DEVICE_CONTEXT*     DeviceContext,
    IN  NAL_DEVICE_LOCATION             PciLocation
    );

#else
/* ===========================================================================================================
 *                                          QV DRIVER PROTOTYPES
   =========================================================================================================*/

#endif

#endif /* SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_ */
